<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Common\DTO;

use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Phone
{
    /**
     * @var string|null
     *
     * @Assert\NotBlank
     * @Assert\Regex("/^\+\d{1,3}$/")
     */
    private $prefix;

    /**
     * @var string|null
     *
     * @Assert\NotBlank
     * @Assert\Regex("/^\d{4,16}$/")
     */
    private $number;

    public function __construct(string $prefix = null, string $number = null)
    {
        $this->prefix = $prefix;
        $this->number = $number;
    }

    public function getPrefix(): ?string
    {
        return $this->prefix;
    }

    public function setPrefix(?string $prefix): self
    {
        $this->prefix = $prefix;

        return $this;
    }

    public function getNumber(): ?string
    {
        return $this->number;
    }

    public function setNumber(?string $number): self
    {
        $this->number = $number;

        return $this;
    }
}
