<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration;

use InPost\International\Configuration\Enum\ClosestPointSearchMode;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CheckoutConfiguration
{
    /**
     * @var ClosestPointSearchMode
     */
    private $closestPointSearchMode;

    public function __construct(ClosestPointSearchMode $closestPointSearchMode)
    {
        $this->closestPointSearchMode = $closestPointSearchMode;
    }

    public function getClosestPointSearchMode(): ClosestPointSearchMode
    {
        return $this->closestPointSearchMode;
    }
}
