<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration\DTO;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface GeocoderConfigInterface
{
    public static function getGeocoderTypeId(): string;

    /**
     * @return static
     */
    public static function fromArray(array $data): GeocoderConfigInterface;

    /**
     * @return array<string, mixed>
     */
    public function toArray(): array;
}
