<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration\DTO;

use InPost\International\Configuration\Validator\GoogleMapsApiKey;
use InPost\International\Geocoding\GoogleMaps\GoogleMapsGeocoder;
use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @Assert\GroupSequence({"GoogleMapsGeocoderConfig", "api"})
 */
final class GoogleMapsGeocoderConfig implements GeocoderConfigInterface
{
    /**
     * @var string|null
     *
     * @Assert\NotBlank
     * @GoogleMapsApiKey(groups="api")
     */
    private $apiKey;

    public static function getGeocoderTypeId(): string
    {
        return GoogleMapsGeocoder::ID;
    }

    public static function fromArray(array $data): GeocoderConfigInterface
    {
        return (new self())
            ->setApiKey($data['api_key'] ?? null);
    }

    /**
     * @return array<string, mixed>
     */
    public function toArray(): array
    {
        return [
            'api_key' => $this->apiKey,
        ];
    }

    public function getApiKey(): ?string
    {
        return $this->apiKey;
    }

    public function setApiKey(?string $apiKey): self
    {
        $this->apiKey = $apiKey;

        return $this;
    }
}
