<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration\Enum;

use InPost\International\Enum\StringEnum;
use InPost\International\Geocoding\GoogleMaps\GoogleMapsGeocoder;
use InPost\International\Translation\TranslatableInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

/**
 * @method static self Disabled()
 * @method static self ByPostcode()
 * @method static self GoogleMapsGeocoder()
 */
final class ClosestPointSearchMode extends StringEnum implements TranslatableInterface
{
    private const DISABLED = 'disabled';
    private const BY_POSTCODE = 'postcode';
    private const GOOGLE_MAPS_GEOCODER = GoogleMapsGeocoder::ID;

    public function trans(TranslatorInterface $translator, string $locale = null): string
    {
        switch ($this) {
            case self::Disabled():
                return $translator->trans('Disabled', [], 'Modules.Inpostinternational.Configuration', $locale);
            case self::ByPostcode():
                return $translator->trans('By delivery address postal code', [], 'Modules.Inpostinternational.Configuration', $locale);
            case self::GoogleMapsGeocoder():
                return $translator->trans('Geocoding the delivery address using the Google Maps API', [], 'Modules.Inpostinternational.Configuration', $locale);
            default:
                throw new \LogicException('Not implemented.');
        }
    }
}
