<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration\Enum;

use InPost\International\Enum\StringEnum;
use InPost\International\Translation\TranslatableInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @method static self OrderNumber()
 * @method static self OrderIdentifier()
 */
final class ShipmentReference extends StringEnum implements TranslatableInterface
{
    private const ORDER_NUMBER = 'order_number';
    private const ORDER_IDENTIFIER = 'order_id';

    public function trans(TranslatorInterface $translator, string $locale = null): string
    {
        switch ($this) {
            case self::OrderNumber():
                return $translator->trans('Order number', [], 'Modules.Inpostinternational.Configuration', $locale);
            case self::OrderIdentifier():
                return $translator->trans('Order identifier', [], 'Modules.Inpostinternational.Configuration', $locale);
            default:
                return $this->name;
        }
    }
}
