<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration;

use InPost\International\Configuration\Validator\ApiCredentials;
use InPost\International\Environment\EnvironmentInterface;
use InPost\International\OAuth2\Authentication\ClientCredentialsInterface;
use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @Assert\GroupSequence({"EnvironmentConfiguration", "api"})
 * @ApiCredentials(groups={"api"})
 */
final class EnvironmentConfiguration
{
    /**
     * @var EnvironmentInterface
     */
    private $environment;

    /**
     * @var ClientCredentialsInterface|null
     *
     * @Assert\Valid
     */
    private $credentials;

    /**
     * @var string|null
     */
    private $geoWidgetToken;

    public function __construct(EnvironmentInterface $environment, ClientCredentialsInterface $credentials = null, string $geoWidgetToken = null)
    {
        $this->environment = $environment;
        $this->credentials = $credentials;
        $this->geoWidgetToken = $geoWidgetToken;
    }

    public function getEnvironment(): EnvironmentInterface
    {
        return $this->environment;
    }

    public function getClientCredentials(): ?ClientCredentialsInterface
    {
        return $this->credentials;
    }

    public function getGeoWidgetToken(): ?string
    {
        return $this->geoWidgetToken;
    }
}
