<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration\Form\Type\Api;

use InPost\International\Environment\EnvironmentInterface;
use InPost\International\Environment\EnvironmentRegistry;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\OptionsResolver\OptionsResolver;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class EnvironmentChoiceType extends AbstractType
{
    /**
     * @var EnvironmentRegistry
     */
    private $registry;

    public function __construct(EnvironmentRegistry $registry)
    {
        $this->registry = $registry;
    }

    public function getParent(): string
    {
        return ChoiceType::class;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'choices' => $this->registry->getAll(),
            'choice_label' => static function (EnvironmentInterface $environment): string {
                return $environment->getName();
            },
            'choice_name' => static function (EnvironmentInterface $environment): string {
                return $environment->getId();
            },
            'choice_value' => static function (?EnvironmentInterface $environment): string {
                if (null === $environment) {
                    return '';
                }

                return $environment->getId();
            },
        ]);
    }
}
