<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class MailsConfiguration
{
    /**
     * @var bool
     */
    private $modifyOrderConfirmation;

    public function __construct(bool $modifyOrderConfirmation = false)
    {
        $this->modifyOrderConfirmation = $modifyOrderConfirmation;
    }

    /**
     * @return bool whether delivery point name should be appended to the carrier name
     */
    public function modifyOrderConfirmation(): bool
    {
        return $this->modifyOrderConfirmation;
    }

    public function withModifyOrderConfirmation(bool $modify): self
    {
        $configuration = clone $this;
        $configuration->modifyOrderConfirmation = $modify;

        return $configuration;
    }
}
