<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration\Message\Factory;

use InPost\International\Configuration\Message\UpdateOrdersConfigurationCommand;
use InPost\International\Configuration\Repository\MailsConfigurationRepositoryInterface;
use InPost\International\Configuration\Repository\OrdersConfigurationRepositoryInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

class UpdateOrdersConfigurationCommandFactory
{
    /**
     * @var MailsConfigurationRepositoryInterface
     */
    private $mailsConfigRepository;
    /**
     * @var OrdersConfigurationRepositoryInterface
     */
    private $ordersConfigRepository;

    public function __construct(OrdersConfigurationRepositoryInterface $ordersConfigRepository, MailsConfigurationRepositoryInterface $mailsConfigRepository)
    {
        $this->mailsConfigRepository = $mailsConfigRepository;
        $this->ordersConfigRepository = $ordersConfigRepository;
    }

    public function createCommand(): UpdateOrdersConfigurationCommand
    {
        $ordersConfig = $this->ordersConfigRepository->getOrdersConfiguration();
        $mailsConfig = $this->mailsConfigRepository->getMailsConfiguration();

        return (new UpdateOrdersConfigurationCommand())
            ->setLabelPrintedStatusId($ordersConfig->getLabelPrintedStatusId())
            ->setShipmentDeliveredStatusId($ordersConfig->getShipmentDeliveredStatusId())
            ->setModifyOrderConfirmationMail($mailsConfig->modifyOrderConfirmation());
    }
}
