<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration\Message;

use InPost\International\Configuration\DTO\GeocoderConfigInterface;
use InPost\International\Configuration\Enum\ClosestPointSearchMode;
use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class UpdateCheckoutConfigurationCommand
{
    /**
     * @var ClosestPointSearchMode|null
     *
     * @Assert\NotBlank
     */
    private $closestPointSerachMode;

    /**
     * @var array<string, GeocoderConfigInterface|null>
     *
     * @Assert\Valid
     */
    private $geocoderConfigs = [];

    public function getClosestPointSerachMode(): ?ClosestPointSearchMode
    {
        return $this->closestPointSerachMode;
    }

    public function setClosestPointSerachMode(?ClosestPointSearchMode $mode): self
    {
        $this->closestPointSerachMode = $mode;

        return $this;
    }

    /**
     * @return array<string, GeocoderConfigInterface|null>
     */
    public function getGeocoderConfigs(): array
    {
        return $this->geocoderConfigs;
    }

    public function getGeocoderConfig(string $type): ?GeocoderConfigInterface
    {
        return $this->geocoderConfigs[$type] ?? null;
    }

    public function addGeocoderConfig(GeocoderConfigInterface $config): self
    {
        $type = $config::getGeocoderTypeId();
        $this->geocoderConfigs[$type] = $config;

        return $this;
    }

    public function removeGeocoderConfig(string $type): self
    {
        $this->geocoderConfigs[$type] = null;

        return $this;
    }

    public function resetGeocoderConfig(string $type): self
    {
        unset($this->geocoderConfigs[$type]);

        return $this;
    }
}
