<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration\Message;

use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class UpdateOrdersConfigurationCommand
{
    /**
     * @var int|null
     *
     * @Assert\GreaterThan(0)
     */
    private $labelPrintedStatusId;

    /**
     * @var int|null
     *
     * @Assert\GreaterThan(0)
     */
    private $shipmentDeliveredStatusId;

    /**
     * @var bool|null
     *
     * @Assert\NotNull
     */
    private $modifyOrderConfirmationMail = false;

    public function getLabelPrintedStatusId(): ?int
    {
        return $this->labelPrintedStatusId;
    }

    public function setLabelPrintedStatusId(?int $labelPrintedStatusId): self
    {
        $this->labelPrintedStatusId = $labelPrintedStatusId;

        return $this;
    }

    public function getShipmentDeliveredStatusId(): ?int
    {
        return $this->shipmentDeliveredStatusId;
    }

    public function setShipmentDeliveredStatusId(?int $shipmentDeliveredStatusId): self
    {
        $this->shipmentDeliveredStatusId = $shipmentDeliveredStatusId;

        return $this;
    }

    public function getModifyOrderConfirmationMail(): ?bool
    {
        return $this->modifyOrderConfirmationMail;
    }

    public function setModifyOrderConfirmationMail(?bool $modifyOrderConfirmationMail): self
    {
        $this->modifyOrderConfirmationMail = $modifyOrderConfirmationMail;

        return $this;
    }
}
