<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class OrdersConfiguration
{
    /**
     * @var int|null
     */
    private $labelPrintedStatusId;

    /**
     * @var int|null
     */
    private $shipmentDeliveredStatusId;

    public function __construct(int $labelPrintedStatusId = null, int $shipmentDeliveredStatusId = null)
    {
        $this->labelPrintedStatusId = $labelPrintedStatusId;
        $this->shipmentDeliveredStatusId = $shipmentDeliveredStatusId;
    }

    public function getLabelPrintedStatusId(): ?int
    {
        return $this->labelPrintedStatusId;
    }

    public function withLabelPrintedStatusId(?int $statusId): self
    {
        $configuration = clone $this;
        $configuration->labelPrintedStatusId = $statusId;

        return $configuration;
    }

    public function getShipmentDeliveredStatusId(): ?int
    {
        return $this->shipmentDeliveredStatusId;
    }

    public function withShipmentDeliveredStatusId(?int $statusId): self
    {
        $configuration = clone $this;
        $configuration->shipmentDeliveredStatusId = $statusId;

        return $configuration;
    }
}
