<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration\Repository;

use InPost\International\Configuration\EnvironmentConfiguration;
use InPost\International\Environment\EnvironmentInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface ApiConfigurationRepositoryInterface
{
    public function getCurrentEnvironment(): EnvironmentInterface;

    public function setCurrentEnvironment(EnvironmentInterface $environment): void;

    /**
     * @return EnvironmentConfiguration[]
     */
    public function getAllConfigurations(): array;

    /**
     * @param string|null $env specific environment ID or null to check the current environment
     *
     * @return bool whether the configuration has all the required credentials
     */
    public function hasConfiguration(string $env = null): bool;

    /**
     * @param string|null $env specific environment ID or null to get configuration for the current environment
     */
    public function getConfiguration(string $env = null): EnvironmentConfiguration;

    public function saveConfiguration(EnvironmentConfiguration $configuration): void;
}
