<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration\Repository;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface GeocodingConfigurationRepositoryInterface
{
    public function getGeocoderTypeId(): ?string;

    /**
     * @return array<string, mixed>|null
     */
    public function getGeocoderOptions(string $type): ?array;

    /**
     * @param array<string, mixed> $options
     */
    public function saveGeocoderOptions(string $type, array $options): void;

    public function removeGeocoderOptions(string $type): void;
}
