<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration;

use InPost\International\Api\Shipment\Model\Sender;
use InPost\International\Api\Shipment\Model\Service\Insurance;
use InPost\International\Configuration\Enum\ShipmentReference;
use InPost\International\Shipment\ShippingMethod;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ShippingConfiguration
{
    /**
     * @var Sender
     */
    private $sender;

    /**
     * @var ShippingMethod
     */
    private $defaultShippingMethod;

    /**
     * @var ShipmentReference
     */
    private $defaultShipmentReference;

    /**
     * @var ShipmentReference|null
     */
    private $defaultParcelComment;

    /**
     * @var Insurance|null
     */
    private $defaultInsurance;

    public function __construct(Sender $sender, ShippingMethod $defaultShippingMethod, ShipmentReference $defaultShipmentReference, ShipmentReference $defaultParcelComment = null, Insurance $defaultInsurance = null)
    {
        $this->sender = $sender;
        $this->defaultShippingMethod = $defaultShippingMethod;
        $this->defaultShipmentReference = $defaultShipmentReference;
        $this->defaultParcelComment = $defaultParcelComment;
        $this->defaultInsurance = $defaultInsurance;
    }

    public function getSender(): Sender
    {
        return $this->sender;
    }

    public function getDefaultShippingMethod(): ShippingMethod
    {
        return $this->defaultShippingMethod;
    }

    public function getDefaultShipmentReference(): ShipmentReference
    {
        return $this->defaultShipmentReference;
    }

    public function getDefaultParcelComment(): ?ShipmentReference
    {
        return $this->defaultParcelComment;
    }

    public function getDefaultInsurance(): ?Insurance
    {
        return $this->defaultInsurance;
    }
}
