<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration\View;

use Twig\Environment;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @implements \IteratorAggregate<string>
 */
final class NavBar implements \Stringable, \IteratorAggregate
{
    /**
     * @var Environment
     */
    private $twig;

    /**
     * @var iterable<NavItem>
     */
    private $items;

    /**
     * @var string|null
     */
    private $content;

    /**
     * @param iterable<NavItem> $items
     */
    public function __construct(Environment $twig, iterable $items)
    {
        $this->twig = $twig;
        $this->items = $items;
    }

    /**
     * @return \Traversable<string>
     */
    public function getIterator(): \Traversable
    {
        yield (string) $this;
    }

    public function __toString(): string
    {
        return $this->content ?? $this->content = $this->render();
    }

    private function render(): string
    {
        return $this->twig->render('@Modules/inpostinternational/views/templates/admin/components/_nav_bar.html.twig', [
            'items' => $this->items,
        ]);
    }
}
