<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Configuration\View;

use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class NavItem
{
    /**
     * @var string
     */
    private $id;

    /**
     * @var string
     */
    private $label;

    /**
     * @var string
     */
    private $route;

    /**
     * @var callable(Request): bool
     */
    private $activeChecker;

    /**
     * @param callable(Request): bool|null $activeChecker
     */
    public function __construct(string $id, string $label, string $route, callable $activeChecker = null)
    {
        $this->id = $id;
        $this->label = $label;
        $this->route = $route;
        $this->activeChecker = $activeChecker ?? [$this, 'checkRoute'];
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getLabel(): string
    {
        return $this->label;
    }

    public function getRoute(): string
    {
        return $this->route;
    }

    public function isCurrent(Request $request): bool
    {
        return ($this->activeChecker)($request);
    }

    private function checkRoute(Request $request): bool
    {
        return $this->route === $request->attributes->get('_route');
    }
}
