<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Controller\Admin;

use InPost\International\Configuration\View\NavBar;
use InPost\International\Configuration\View\NavItem;
use InPost\International\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

abstract class AbstractConfigurationController extends AbstractController
{
    final protected function getNavBar(): NavBar
    {
        return new NavBar($this->get('twig'), $this->getNavItems());
    }

    private function getNavItems(): iterable
    {
        yield new NavItem('api', $this->trans('API configuration', [], 'Modules.Inpostinternational.Configuration'), 'admin_inpost_intl_config_api');
        yield new NavItem('carriers', $this->trans('Services', [], 'Modules.Inpostinternational.Carrier'), 'admin_inpost_intl_carriers_index', static function (Request $request): bool {
            return $request->attributes->has('_inpost_intl_carriers_page');
        });
        yield new NavItem('checkout', $this->trans('Checkout', [], 'Modules.Inpostinternational.Configuration'), 'admin_inpost_intl_config_checkout');
        yield new NavItem('shipping', $this->trans('Shipping', [], 'Modules.Inpostinternational.Configuration'), 'admin_inpost_intl_config_shipping');
        yield new NavItem('parcel_templates', $this->trans('Parcel templates', [], 'Modules.Inpostinternational.Configuration'), 'admin_inpost_intl_parcel_templates_index', static function (Request $request): bool {
            return $request->attributes->has('_inpost_intl_parcel_templates_page');
        });
        yield new NavItem('orders', $this->trans('Orders', [], 'Modules.Inpostinternational.Configuration'), 'admin_inpost_intl_config_orders');
        yield new NavItem('pickup_addresses', $this->trans('Pickup addresses', [], 'Modules.Inpostinternational.Configuration'), 'admin_inpost_intl_pickup_addresses_index', static function (Request $request): bool {
            return $request->attributes->has('_inpost_intl_pickup_addresses_page');
        });
    }
}
