<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Delivery;

use InPost\International\Country;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Address implements \Stringable
{
    /**
     * @var string
     */
    private $address;

    /**
     * @var string
     */
    private $postcode;

    /**
     * @var string
     */
    private $city;

    /**
     * @var Country
     */
    private $country;

    public function __construct(string $address, string $postcode, string $city, Country $country)
    {
        $this->address = $address;
        $this->postcode = $postcode;
        $this->city = $city;
        $this->country = $country;
    }

    public function getAddress(): string
    {
        return $this->address;
    }

    public function getPostcode(): string
    {
        return $this->postcode;
    }

    public function getCity(): string
    {
        return $this->city;
    }

    public function getCountry(): Country
    {
        return $this->country;
    }

    public function __toString(): string
    {
        return sprintf('Delivery address: %s', json_encode([
            'address' => $this->address,
            'postcode' => $this->postcode,
            'city' => $this->city,
            'country' => $this->country,
        ]));
    }
}
