<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Delivery\AvailabilityChecker;

use InPost\International\Entity\Carrier;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ChainAvailabilityChecker implements CarrierAvailabilityCheckerInterface
{
    /**
     * @var iterable<CarrierAvailabilityCheckerInterface>
     */
    private $checkers;

    /**
     * @param iterable<CarrierAvailabilityCheckerInterface> $checkers
     */
    public function __construct(iterable $checkers)
    {
        $this->checkers = $checkers;
    }

    public function isAvailable(Carrier $carrier, \Cart $cart): bool
    {
        foreach ($this->checkers as $checker) {
            assert($checker instanceof CarrierAvailabilityCheckerInterface);

            if (!$checker->isAvailable($carrier, $cart)) {
                return false;
            }
        }

        return true;
    }
}
