<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Delivery\Calculator;

use InPost\International\Entity\Carrier;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface ShippingCostCalculatorInterface
{
    /**
     * @param float $shippingCost shipping cost calculated by core
     */
    public function calculate(\Cart $cart, Carrier $carrier, float $shippingCost): float;
}
