<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Delivery\Point\Cache;

use InPost\International\Delivery\Point\RelativePointInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ClosestPointCache
{
    /**
     * @var SimpleRelativePoint|null
     */
    private $point;

    /**
     * @var string
     */
    private $checksum;

    /**
     * @var \DateTimeImmutable
     */
    private $createdAt;

    public function __construct(?SimpleRelativePoint $point, string $checksum, \DateTimeImmutable $createdAt)
    {
        $this->point = $point;
        $this->checksum = $checksum;
        $this->createdAt = $createdAt;
    }

    public static function create(?RelativePointInterface $point, string $checksum, \DateTimeImmutable $createdAt): self
    {
        return new self($point ? SimpleRelativePoint::fromPoint($point) : null, $checksum, $createdAt);
    }

    public function getPoint(): ?SimpleRelativePoint
    {
        return $this->point;
    }

    public function getChecksum(): string
    {
        return $this->checksum;
    }

    public function getCreatedAt(): \DateTimeImmutable
    {
        return $this->createdAt;
    }
}
