<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Delivery\Point;

use InPost\International\Api\Point\Model\PointCapability;
use InPost\International\Delivery\Address;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface ClosestPointFinderInterface
{
    public function findClosestPoint(Address $address, PointCapability ...$capabilities): ?RelativePointInterface;
}
