<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Delivery\Point;

use InPost\International\Api\Point\Model\Address;
use InPost\International\Api\Point\Model\PointCapability;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface PointInterface
{
    public function getId(): string;

    public function getType(): string;

    public function getCountry(): string;

    /**
     * @return string[]
     */
    public function getCapabilities(): array;

    public function hasCapability(PointCapability $capability): bool;

    public function getAddress(): Address;
}
