<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Delivery\Point\Presenter;

use InPost\International\Delivery\Point\PointInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface PointPresenterInterface
{
    public function formatName(PointInterface $point, string $locale = null): string;

    public function formatAddress(PointInterface $point, string $locale = null): string;
}
