<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Delivery;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ShippingCostCalculationParameters
{
    /**
     * @var \Cart
     */
    private $cart;

    /**
     * @var int
     */
    private $carrierId;

    /**
     * @var float|null
     */
    private $shippingCost;

    /**
     * @param int $carrierId {@see \Carrier} identifier
     * @param float|null $shippingCost shipping cost calculated by core
     */
    public function __construct(\Cart $cart, int $carrierId, float $shippingCost = null)
    {
        $this->cart = $cart;
        $this->carrierId = $carrierId;
        $this->shippingCost = $shippingCost;
    }

    public function getCart(): \Cart
    {
        return $this->cart;
    }

    public function getCarrierId(): int
    {
        return $this->carrierId;
    }

    public function getShippingCost(): ?float
    {
        return $this->shippingCost;
    }
}
