<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Delivery\Validator;

use InPost\International\Country;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Exception\InvalidArgumentException;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @Annotation
 * @Target({"PROPERTY", "METHOD", "ANNOTATION"})
 */
final class DeliveryPointId extends Constraint
{
    /**
     * @var Country|null
     */
    public $country;

    public function __construct($options = null)
    {
        parent::__construct($options);

        if (null !== $this->country && !$this->country instanceof Country) {
            throw new InvalidArgumentException(sprintf('The "country" option must be an instance of "%s" ("%s" given).', Country::class, get_debug_type($this->country)));
        }
    }

    public function getDefaultOption(): string
    {
        return 'country';
    }
}
