<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Entity;

use Doctrine\ORM\Mapping as ORM;
use InPost\International\Checkout\CheckoutSessionRepository;
use InPost\International\Delivery\Point\PointInterface;
use PrestaShop\PrestaShop\Core\Domain\Cart\ValueObject\CartId;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @final
 *
 * @ORM\Entity(repositoryClass=CheckoutSessionRepository::class)
 * @ORM\Table(name=CheckoutSession::TABLE_NAME)
 */
class CheckoutSession
{
    /**
     * @internal
     */
    public const TABLE_NAME = _DB_PREFIX_ . 'inpost_intl_checkout_session';

    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\Column(type="integer", name="id_cart")
     */
    private $cartId;

    /**
     * @var array<int, string> point IDs by carrier ID
     *
     * @ORM\Column(type="json")
     */
    private $points = [];

    public function __construct(CartId $cartId)
    {
        $this->cartId = $cartId->getValue();
    }

    public function getCartId(): int
    {
        return $this->cartId;
    }

    /**
     * @return array<int, string> point IDs by carrier ID
     */
    public function getPointIds(): array
    {
        return $this->points;
    }

    public function getPointId(int $carrierId): ?string
    {
        return $this->points[$carrierId] ?? null;
    }

    public function selectDeliveryPoint(PointDeliveryCarrier $carrier, PointInterface $point): void
    {
        $this->points[$carrier->getReferenceId()] = $point->getId();
    }

    public function resetDeliveryOptions(): void
    {
        $this->points = [];
    }
}
