<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Entity;

use Doctrine\ORM\Mapping as ORM;
use InPost\International\Api\Shipment\Model\Parcel\ParcelType;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Embeddable
 */
final class Parcel
{
    /**
     * @var string
     *
     * @ORM\Column(type="string")
     */
    private $type;

    /**
     * @var Dimensions
     *
     * @ORM\Embedded(class=Dimensions::class, columnPrefix=false)
     */
    private $dimensions;

    /**
     * @var Weight
     *
     * @ORM\Embedded(class=Weight::class, columnPrefix=false)
     */
    private $weight;

    /**
     * @var string|null
     *
     * @ORM\Column(type="string")
     */
    private $comment;

    public function __construct(ParcelType $type, Dimensions $dimensions, Weight $weight, string $comment = null)
    {
        $this->type = $type->value;
        $this->dimensions = $dimensions;
        $this->weight = $weight;
        $this->comment = $comment;
    }

    public function getType(): ParcelType
    {
        return ParcelType::from($this->type);
    }

    public function getDimensions(): Dimensions
    {
        return $this->dimensions;
    }

    public function getWeight(): Weight
    {
        return $this->weight;
    }

    public function getComment(): ?string
    {
        return $this->comment;
    }
}
