<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Entity;

use Doctrine\ORM\Mapping as ORM;
use InPost\International\Carrier\CarrierType;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @final
 *
 * @ORM\Entity
 */
class PointDeliveryCarrier extends Carrier
{
    /**
     * @internal
     */
    public const TYPE = 'point_delivery';

    public function getType(): CarrierType
    {
        return CarrierType::PointDelivery();
    }
}
