<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Environment;

use InPost\International\OAuth2\UriCollectionInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface EnvironmentInterface
{
    public function getId(): string;

    public function getName(): string;

    public function isTestEnvironment(): bool;

    public function getApiUri(): string;

    public function getOAuth2UriCollection(): UriCollectionInterface;

    public function getGeoWidgetUri(): string;
}
