<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\EventDispatcher;

use Symfony\Component\EventDispatcher\Event as LegacyEvent;
use Symfony\Contracts\EventDispatcher\Event as BaseEvent;

if (!defined('_PS_VERSION_')) {
    exit;
}

if (class_exists(LegacyEvent::class)) {
    class Event extends LegacyEvent
    {
    }
} else {
    class Event extends BaseEvent
    {
    }
}
