<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\EventDispatcher\Util;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class SubscriberUtil
{
    private function __construct()
    {
    }

    /**
     * Normalizes possible values of {@see EventSubscriberInterface::getSubscribedEvents()}.
     *
     * @param string|array{0: string, 1: int}|list<array{0: string, 1?: int}> $listeners
     *
     * @return list<array{0: string, 1: int}>
     */
    public static function normalizeListeners($listeners): array
    {
        if (is_string($listeners)) {
            return [[$listeners, 0]];
        }

        if (is_string($listeners[0])) {
            return [[$listeners[0], $listeners[1]]];
        }

        return array_map(static function ($listener) {
            return [$listener[0], $listener[1] ?? 0];
        }, $listeners);
    }
}
