<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\File;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Base64EncodedFile implements StreamableInterface
{
    /**
     * @var string
     */
    private $content;

    /**
     * @var string
     */
    private $contentType;

    /**
     * @var string
     */
    private $filename;

    public function __construct(string $content, string $contentType, string $filename)
    {
        $this->content = $content;
        $this->contentType = $contentType;
        $this->filename = $filename;
    }

    public function stream(): void
    {
        $outputStream = fopen('php://output', 'wb');
        stream_filter_append($outputStream, 'convert.base64-decode');
        fwrite($outputStream, $this->content);
        fclose($outputStream);
    }

    public function getContentType(): string
    {
        return $this->contentType;
    }

    public function getFilename(): string
    {
        return $this->filename;
    }
}
