<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Form\TypeExtension;

use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Backports some of the options introduced in Symfony 4.x.
 *
 * @internal
 *
 * @deprecated to be removed when we drop support for PS 1.7
 */
final class NumberCompatibilityTypeExtension extends AbstractTypeExtension
{
    public static function getExtendedTypes(): iterable
    {
        return [NumberType::class];
    }

    public function getExtendedType(): string
    {
        return NumberType::class;
    }

    public function buildView(FormView $view, FormInterface $form, array $options): void
    {
        if ($options['html5']) {
            $view->vars['type'] = 'number';
        }
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        if (!$resolver->isDefined('html5')) {
            $resolver
                ->setDefault('html5', false)
                ->setAllowedTypes('html5', 'bool');
        }
    }
}
