<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Geocoding;

use InPost\International\Api\Point\Model\Coordinates;
use InPost\International\Delivery\Address;
use InPost\International\Geocoding\Exception\GeocodingException;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface GeocoderInterface
{
    /**
     * @throws GeocodingException
     */
    public function geocode(Address $address): ?Coordinates;
}
