<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Geocoding\GoogleMaps;

use InPost\International\Geocoding\GeocoderInterface;
use InPost\International\Geocoding\SpecializedGeocoderFactoryInterface;
use InPost\International\Http\Client\Factory\ClientFactoryInterface;
use Psr\Http\Message\RequestFactoryInterface;
use Symfony\Component\Serializer\SerializerInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class GoogleMapsGeocoderFactory implements SpecializedGeocoderFactoryInterface
{
    /**
     * @var ClientFactoryInterface
     */
    private $clientFactory;

    /**
     * @var RequestFactoryInterface
     */
    private $requestFactory;

    /**
     * @var SerializerInterface
     */
    private $serializer;

    public function __construct(ClientFactoryInterface $clientFactory, RequestFactoryInterface $requestFactory, SerializerInterface $serializer)
    {
        $this->clientFactory = $clientFactory;
        $this->requestFactory = $requestFactory;
        $this->serializer = $serializer;
    }

    public static function getGeocoderTypeId(): string
    {
        return GoogleMapsGeocoder::ID;
    }

    public function create(array $options): GeocoderInterface
    {
        if (empty($options['api_key'])) {
            throw new \LogicException('API key is required.');
        }

        $client = $this->clientFactory->create($options['http_client_options'] ?? []);

        return new GoogleMapsGeocoder($client, $this->requestFactory, $this->serializer, (string) $options['api_key']);
    }
}
