<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Geocoding\GoogleMaps\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class GeocodingResponse
{
    public const STATUS_OK = 'OK';
    public const STATUS_ZERO_RESULTS = 'ZERO_RESULTS';

    /**
     * @var string
     */
    private $status;

    /**
     * @var GeocodingResult[]
     */
    private $results;

    /**
     * @var string|null
     */
    private $error_message;

    /**
     * @param GeocodingResult[] $results
     */
    public function __construct(string $status, array $results, string $error_message = null)
    {
        $this->status = $status;
        $this->results = $results;
        $this->error_message = $error_message;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    /**
     * @return GeocodingResult[]
     */
    public function getResults(): array
    {
        return $this->results;
    }

    public function getFirstResult(): ?GeocodingResult
    {
        return $this->results[0] ?? null;
    }

    public function getErrorMessage(): ?string
    {
        return $this->error_message;
    }
}
