<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Geocoding\GoogleMaps\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class GeocodingResult
{
    /**
     * @var Geometry
     */
    private $geometry;

    /**
     * @var bool
     */
    private $partial_match;

    public function __construct(Geometry $geometry, bool $partial_match = false)
    {
        $this->geometry = $geometry;
        $this->partial_match = $partial_match;
    }

    public function getGeometry(): Geometry
    {
        return $this->geometry;
    }

    public function isPartialMatch(): bool
    {
        return $this->partial_match;
    }
}
