<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Geocoding;

use InPost\International\Api\Point\Model\Coordinates;
use InPost\International\Delivery\Address;
use Psr\Log\LoggerInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class LoggingGeocoder implements GeocoderInterface
{
    /**
     * @var GeocoderInterface
     */
    private $geocoder;

    /**
     * @var LoggerInterface
     */
    private $logger;

    public function __construct(GeocoderInterface $geocoder, LoggerInterface $logger)
    {
        $this->geocoder = $geocoder;
        $this->logger = $logger;
    }

    public function geocode(Address $address): ?Coordinates
    {
        try {
            return $this->geocoder->geocode($address);
        } catch (\Throwable $e) {
            $this->logger->error('Geocoding failed.', [
                'exception' => $e,
            ]);

            throw $e;
        }
    }
}
