<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Hook\Event\Admin;

use InPost\International\Hook\Event\AbstractDisplayHook;
use InPost\International\PrestaShop\Grid\Model\PresentedGrid;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class DisplayGridTableAfterEvent extends AbstractDisplayHook
{
    public const NAME = 'displayAdminGridTableAfter';

    /**
     * @var PresentedGrid
     */
    private $grid;

    public function __construct(PresentedGrid $grid, Request $request = null)
    {
        $this->grid = $grid;
        $this->request = $request;
    }

    public function getName(): string
    {
        return self::NAME;
    }

    public function getGrid(): PresentedGrid
    {
        return $this->grid;
    }
}
