<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Hook\Event\Front;

use InPost\International\Hook\Event\AbstractActionHook;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ControllerInitializedEvent extends AbstractActionHook
{
    public const NAME = 'actionFrontControllerInitAfter';

    /**
     * @var \FrontController
     */
    private $controller;

    public function __construct(\FrontController $controller, Request $request = null)
    {
        $this->controller = $controller;
        $this->request = $request;
    }

    public function getName(): string
    {
        return self::NAME;
    }

    public function getController(): \FrontController
    {
        return $this->controller;
    }
}
