<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Hook;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface HookDispatcherInterface
{
    /**
     * @param string $name hook name
     * @param array<string, mixed> $parameters hook parameters
     *
     * @return mixed hook result
     */
    public function dispatch(string $name, array $parameters);
}
