<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Hook;

use Symfony\Component\HttpFoundation\RequestStack;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ParametersNormalizingHookDispatcher implements HookDispatcherInterface
{
    /**
     * @var HookDispatcherInterface
     */
    private $dispatcher;

    /**
     * @var RequestStack
     */
    private $requestStack;

    public function __construct(HookDispatcherInterface $dispatcher, RequestStack $requestStack)
    {
        $this->dispatcher = $dispatcher;
        $this->requestStack = $requestStack;
    }

    /**
     * {@inheritDoc}
     */
    public function dispatch(string $name, array $parameters)
    {
        if (!array_key_exists('request', $parameters) && null !== $request = $this->requestStack->getCurrentRequest()) {
            $parameters['request'] = $request;
        }

        return $this->dispatcher->dispatch($name, $parameters);
    }
}
