<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Hook\Serializer;

use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Prevents denormalization of objects that already are instances of the given type.
 *
 * @internal
 */
final class DummyDenormalizer implements DenormalizerInterface
{
    public function denormalize($data, $type, $format = null, array $context = []): object
    {
        return $data;
    }

    public function supportsDenormalization($data, $type, $format = null): bool
    {
        return is_object($data) && is_a($data, $type);
    }
}
