<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Http\Exception;

use Psr\Http\Client\NetworkExceptionInterface;
use Psr\Http\Message\RequestInterface;

/**
 * @mixin NetworkExceptionInterface
 */
trait NetworkExceptionDecoratorTrait
{
    /**
     * @var RequestInterface
     */
    private $request;

    public function __construct(NetworkExceptionInterface $previous)
    {
        parent::__construct($previous->getMessage(), $previous->getCode(), $previous);
        $this->request = $previous->getRequest();
    }

    public function getRequest(): RequestInterface
    {
        return $this->request;
    }
}
