<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\HttpFoundation;

use InPost\International\HttpFoundation\Exception\BadRequestException;
use Symfony\Component\HttpFoundation\Exception\RequestExceptionInterface;
use Symfony\Component\HttpFoundation\InputBag;
use Symfony\Component\HttpFoundation\ParameterBag;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class RequestHelper
{
    /**
     * @throws (RequestExceptionInterface&\Throwable)
     */
    public static function getAll(ParameterBag $bag, string $key): array
    {
        if ($bag instanceof InputBag) {
            return $bag->all($key);
        }

        $value = $bag->get($key) ?? [];

        if (!is_array($value)) {
            throw new BadRequestException(sprintf('Unexpected value for parameter "%s": expecting "array", got "%s".', $key, get_debug_type($value)));
        }

        return $value;
    }
}
