<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Installer;

use InPost\International\Installer\Exception\CoreInstallationException;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CoreInstaller implements InstallerInterface, UninstallerInterface
{
    public function install(\Module $module): void
    {
        $installer = \Closure::bind(function () {
            /* @phpstan-ignore class.noParent */
            return parent::install();
        }, $module, get_class($module));

        if ($installer()) {
            return;
        }

        throw CoreInstallationException::create($module);
    }

    public function uninstall(\Module $module, bool $keepData): void
    {
        $uninstaller = \Closure::bind(function () {
            /* @phpstan-ignore class.noParent */
            return parent::uninstall();
        }, $module, get_class($module));

        if ($uninstaller()) {
            return;
        }

        throw CoreInstallationException::create($module);
    }
}
