<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Installer\Exception;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CoreInstallationException extends InstallerException
{
    public static function create(\Module $module): self
    {
        $message = (string) current($module->getErrors());

        return new self($message);
    }
}
